% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_plots.R
\name{plot_MBRgain}
\alias{plot_MBRgain}
\title{Plot MaxQuant Match-between-runs id transfer performance as a scatterplot.}
\usage{
plot_MBRgain(data, title_sub = "")
}
\arguments{
\item{data}{A data.frame with columns as described above}

\item{title_sub}{Subtitle text}
}
\value{
GGplot object
}
\description{
Per Raw file, the absolute number of transferred IDs as well as the relative gain in percent.
}
\details{
The input is a data.frame with columns
  'fc.raw.file' - raw file name
  'abs' - absolute number of transferred ID's
  'pc' - gain on top of genuine IDs [%]
where each row represents one rawfile.
}
\examples{
 data = data.frame(fc.raw.file = paste("file", letters[1:4]),
                   abs = c(5461, 5312, 3618, 502),
                   pc = c(34, 32, 22, 2))
 plot_MBRgain(data, "MBR gain: 18\%")

}
