% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PVBcorrect.R
\docType{package}
\name{PVBcorrect-package}
\alias{PVBcorrect}
\alias{PVBcorrect-package}
\title{PVBcorrect: A package to perform partial verification bias correction for estimates of accuracy measures in diagnostic accuracy studies}
\description{
The package contains a number of functions to perform partial verification bias
(PVB) correction for estimates of accuracy measures in diagnostic accuracy studies.
The available methods are: Begg and Greenes' method (as extended by Alonzo & Pepe, 2005),
Begg and Greenes' method 1 and 2 (with PPV and NPV as extended by deGroot et al, 2011),
Inverse Probability Bootstrap (IPB) sampling method (Arifin & Yusof, 2022; Nahorniak et al., 2015),
Scaled Inverse Probability Resampling methods (Arifin & Yusof, 2023; Arifin & Yusof, 2025),
multiple imputation method by logistic regression (Harel & Zhou, 2006),
and EM-based logistic regression method (Kosinski & Barnhart, 2003).
}
\section{General function}{

\code{\link{view_table}}
}

\section{PVB correction main functions}{

\code{\link{acc_cca}}, \code{\link{acc_ebg}}, \code{\link{acc_ipb}}, \code{\link{acc_sipw}}, \code{\link{acc_mi}}, \code{\link{acc_em}}
}

\section{PVB correction additional functions}{

\code{\link{acc_bg}}, \code{\link{acc_dg1}}, \code{\link{acc_dg2}}
}

\section{Data set}{

\code{\link{cad_pvb}}
}

\references{
\enumerate{
  \item{Alonzo, T. A., & Pepe, M. S. (2005). Assessing accuracy of a continuous screening test in the presence of verification bias. Journal of the Royal Statistical Society: Series C (Applied Statistics), 54(1), 173–190.}
  \item{Arifin, W. N., & Yusof, U. K. (2025). Partial Verification Bias Correction Using Scaled Inverse Probability Resampling for Binary Diagnostic Tests. medRxiv. https://doi.org/10.1101/2025.03.09.25323631}
  \item{Arifin, W. N., & Yusof, U. K. (2022). Partial Verification Bias Correction Using Inverse Probability Bootstrap Sampling for Binary Diagnostic Tests. Diagnostics, 12(11), 2839.}
  \item{Arifin, W. N. (2023). Partial verification bias correction in diagnostic accuracy studies using propensity score-based methods (PhD thesis, Universiti Sains Malaysia). https://erepo.usm.my/handle/123456789/19184}
  \item{Arifin, W. N., & Yusof, U. K. (2022). Partial Verification Bias Correction Using Inverse Probability Bootstrap Sampling for Binary Diagnostic Tests. Diagnostics, 12, 2839.}
  \item{Begg, C. B., & Greenes, R. A. (1983). Assessment of diagnostic tests when disease verification is subject to selection bias. Biometrics, 207–215.}
  \item{de Groot, J. A. H., Janssen, K. J. M., Zwinderman, A. H., Bossuyt, P. M. M., Reitsma, J. B., & Moons, K. G. M. (2011). Correcting for partial verification bias: a comparison of methods. Annals of Epidemiology, 21(2), 139–148.}
  \item{Harel, O., & Zhou, X.-H. (2006). Multiple imputation for correcting verification bias. Statistics in Medicine, 25(22), 3769–3786.}
  \item{He, H., & McDermott, M. P. (2012). A robust method using propensity score stratification for correcting verification bias for binary tests. Biostatistics, 13(1), 32–47.}
  \item{Kosinski, A. S., & Barnhart, H. X. (2003). Accounting for nonignorable verification bias in assessment of diagnostic tests. Biometrics, 59(1), 163–171.}
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/wnarifin/PVBcorrect/}
}

}
\author{
\strong{Maintainer}: Wan Nor Arifin \email{wnarifin@gmail.com} (\href{https://orcid.org/0000-0001-7786-4251}{ORCID}) [copyright holder]

}
