\name{DGP}
\alias{DGP}
\title{Data Generating Process}
\description{
  Generates \eqn{(X, D, Y)} for simulations: multivariate normal X with
  AR(1)-type covariance, treatment D from a linear confounding model plus
  noise, and outcome Y = rho*D + f(X) + error.
}
\usage{
DGP(n, q, p, p.nonzero, rho, Beta, Gamma, mu = rep(10, p), sigma = 0.5,
    f_func = f_0, g_func = g_0, seed = NULL)
}
\arguments{
  \item{n}{Sample size.}
  \item{q}{Causal dimension (kept for interface; unused in current body).}
  \item{p}{Nuisance dimension (number of covariates).}
  \item{p.nonzero}{Number of non-zero coefficients for Beta and Gamma.}
  \item{rho}{Causal effect (scalar).}
  \item{Beta}{Nuisance coefficient vector for outcome; \eqn{p \times 1}.}
  \item{Gamma}{Nuisance coefficient vector for treatment; \eqn{p \times 1}.}
  \item{mu}{Mean vector of X; length \code{p}.}
  \item{sigma}{Base for AR(1)-type covariance: \eqn{\Sigma_{i,j} = \sigma^{|i-j|}}.}
  \item{f_func}{Function \code{f(X, Beta)} for outcome nuisance; default \code{f_0}.}
  \item{g_func}{Function \code{g(X, Gamma)} for treatment equation; default \code{g_0}.}
  \item{seed}{Optional random seed.}
}
\value{
  A list with components \code{D} (treatment), \code{X} (design matrix),
  \code{Y} (outcome), and \code{data} (\code{cbind(Y, D, X)}).
}
\examples{
  set.seed(1)
  n <- 50
  p <- 10
  p.nz <- 3
  Beta <- matrix(c(rep(0.5, p.nz), rep(0, p - p.nz)))
  Gamma <- matrix(c(rep(0.3, p.nz), rep(0, p - p.nz)))
  dat <- DGP(n, q = 1, p, p.nz, rho = 0.5, Beta, Gamma, seed = 1)
  str(dat)
}
\seealso{
  \code{\link{f_0}}, \code{\link{g_0}}, \code{\link{f_k}}, \code{\link{g_k}},
  \code{\link{fit_PTL}}, \code{\link{RMSE}}
}
