% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.profilePredict.R
\name{print.profilePredict}
\alias{print.profilePredict}
\title{Print Objects of the S3 Class \code{profilePredict}}
\usage{
\method{print}{profilePredict}(x, fancy.print = getOption("profileLadder.fancy", TRUE), ...)
}
\arguments{
\item{x}{an object of the class \code{profileLadder} resulting from a call
of one of the functions \code{parallelReserve()} or \code{mcReserve}}

\item{fancy.print}{logical to indicate whether a fancy run-off triangle should be
printed in the output (DEFAULT) or a standard print option should be used instead.
Note that that the fancy print option uses, by DEFAULT, zero number of decimal digits.
Specific colors for the fancy print option and the number of decimal points
to be used can be set by the function \code{set.fancy.print()}.
The fancy print option can be supressed by \code{options(profileLadder.fancy = FALSE)}.}

\item{...}{further arguments passed to \code{print()}}
}
\value{
displays information resulting from a call of the \code{predict()} applied to the
output of the \code{parallelReserve()} or \code{mcReserve()} function---the one year ahead
prediction in the run-off triagle
}
\description{
Function to organize and print the 1-year prediction based on the PARALLAX and REACT
algorithm  (\code{parallelReserve()}) or the MACRAME algorithm (\code{mcReserve()})
}
\examples{
data(CameronMutual)
predict(parallelReserve(CameronMutual))

}
\seealso{
\code{\link[=parallelReserve]{parallelReserve()}}, \code{\link[=mcReserve]{mcReserve()}}, \code{\link[=set.fancy.print]{set.fancy.print()}}
}
