% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.R
\name{measures}
\alias{measures}
\alias{bias}
\alias{bias_mcse}
\alias{relative_bias}
\alias{relative_bias_mcse}
\alias{mse}
\alias{mse_mcse}
\alias{rmse}
\alias{rmse_mcse}
\alias{empirical_variance}
\alias{empirical_variance_mcse}
\alias{empirical_se}
\alias{empirical_se_mcse}
\alias{coverage}
\alias{coverage_mcse}
\alias{mean_ci_width}
\alias{mean_ci_width_mcse}
\alias{interval_score}
\alias{interval_score_mcse}
\alias{power}
\alias{power_mcse}
\alias{positive_likelihood_ratio}
\alias{positive_likelihood_ratio_mcse}
\alias{negative_likelihood_ratio}
\alias{negative_likelihood_ratio_mcse}
\alias{mean_generic_statistic}
\alias{mean_generic_statistic_mcse}
\title{Performance Measures and Monte Carlo Standard Errors}
\usage{
bias(theta_hat, theta)

bias_mcse(theta_hat)

relative_bias(theta_hat, theta)

relative_bias_mcse(theta_hat, theta)

mse(theta_hat, theta)

mse_mcse(theta_hat, theta)

rmse(theta_hat, theta)

rmse_mcse(theta_hat, theta)

empirical_variance(theta_hat)

empirical_variance_mcse(theta_hat)

empirical_se(theta_hat)

empirical_se_mcse(theta_hat)

coverage(ci_lower, ci_upper, theta)

coverage_mcse(ci_lower, ci_upper, theta)

power(test_rejects_h0)

power_mcse(test_rejects_h0)

mean_ci_width(ci_upper, ci_lower)

mean_ci_width_mcse(ci_upper, ci_lower)

mean_generic_statistic(G)

mean_generic_statistic_mcse(G)

positive_likelihood_ratio(tp, fp, fn, tn)

positive_likelihood_ratio_mcse(tp, fp, fn, tn)

negative_likelihood_ratio(tp, fp, fn, tn)

negative_likelihood_ratio_mcse(tp, fp, fn, tn)

interval_score(ci_lower, ci_upper, theta, alpha = 0.05)

interval_score_mcse(ci_lower, ci_upper, theta, alpha = 0.05)
}
\arguments{
\item{theta_hat}{Vector of parameter estimates from simulations}

\item{theta}{True parameter value}

\item{ci_lower}{Vector of lower confidence interval bounds}

\item{ci_upper}{Vector of upper confidence interval bounds}

\item{test_rejects_h0}{Logical vector indicating whether statistical tests reject the null hypothesis}

\item{G}{Vector of generic statistics from simulations}

\item{tp}{Numeric with the count of true positive hypothesis tests}

\item{fp}{Numeric with the count of false positive hypothesis tests}

\item{fn}{Numeric with the count of false negative hypothesis tests}

\item{tn}{Numeric with the count of true negative hypothesis tests}

\item{alpha}{Numeric indicating the 1 - coverage level for interval_score calculation}
}
\value{
Each metric function returns a numeric value representing the performance measure.
Each MCSE function returns a numeric value representing the Monte Carlo standard error.
}
\description{
A comprehensive set of functions for computing performance measures and their
Monte Carlo Standard Errors (MCSE) for simulation studies. All functions are
based on definitions from Table 3 in
\insertCite{siepe2024simulation;textual}{PublicationBiasBenchmark}. Winkler
interval score is defined in \insertCite{winkler1972decision;textual}{PublicationBiasBenchmark}.
Positive and negative likelihood ratios are defined in
\insertCite{huang2023relative;textual}{PublicationBiasBenchmark} and
\insertCite{deeks2004diagnostic;textual}{PublicationBiasBenchmark}. Also see
\insertCite{morris2019using;textual}{PublicationBiasBenchmark} for additional
details. Bias and relative bias were modified to account for possibly different
true values across repetitions.
}
\details{
The package provides the following performance measures and their corresponding MCSE functions:

\itemize{
\item \code{bias(theta_hat, theta)}: Bias estimate
\item \code{relative_bias(theta_hat, theta)}: Relative bias estimate
\item \code{mse(theta_hat, theta)}: Mean Square Error
\item \code{rmse(theta_hat, theta)}: Root Mean Square Error
\item \code{empirical_variance(theta_hat)}: Empirical variance
\item \code{empirical_se(theta_hat)}: Empirical standard error
\item \code{coverage(ci_lower, ci_upper, theta)}: Coverage probability
\item \code{mean_ci_width(ci_upper, ci_lower)}: Mean confidence interval width
\item \code{interval_score(ci_lower, ci_upper, theta, alpha)}: interval_score
\item \code{power(test_rejects_h0)}: Statistical power
\item \code{positive_likelihood_ratio(tp, fp, fn, tn)}: Log positive likelihood ratio
\item \code{negative_likelihood_ratio(tp, fp, fn, tn)}: Log negative likelihood ratio
\item \code{mean_generic_statistic(G)}: Mean of any generic statistic
}
}
\examples{
# Generate some example data
set.seed(123)
theta_true <- 0.5
theta_estimates <- rnorm(1000, mean = theta_true, sd = 0.1)

# Compute bias and its MCSE
bias_est <- bias(theta_estimates, theta_true)
bias_se <- bias_mcse(theta_estimates)

# Compute MSE and its MCSE
mse_est <- mse(theta_estimates, theta_true)
mse_se <- mse_mcse(theta_estimates, theta_true)

# Example with coverage
ci_lower <- theta_estimates - 1.96 * 0.1
ci_upper <- theta_estimates + 1.96 * 0.1
coverage_est <- coverage(ci_lower, ci_upper, theta_true)
coverage_se <- coverage_mcse(ci_lower, ci_upper, theta_true)

}
\references{
\insertAllCited{}
}
