% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{ppl_rm_extra_DVcols}
\alias{ppl_rm_extra_DVcols}
\title{Checks for and removes unnecessary DV output columns.}
\usage{
ppl_rm_extra_DVcols(data, Keep = NULL)
}
\arguments{
\item{data}{A data frame object created from an Eyelink Sample Report.}

\item{Keep}{An optional string or character vector containing the column names
of SR Research sample report columns the user would like to keep in the data set.}
}
\value{
An object of type data table as described in \link[tibble]{tibble}.
}
\description{
\code{ppl_rm_extra_DVcols} checks for unnecessary DataViewer output columns and
removes them, unless specified.
}
\examples{
# Load example data
data("Pupilex1")

dat <- ppl_rm_extra_DVcols(Pupilex1, Keep = NULL)

# Please see the vignettes for detailed example usage.
# vignette("PupilPre_Basic_Preprocessing", package="PupilPre")

}
