% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_custom_read.R
\name{rvn_custom_read}
\alias{rvn_custom_read}
\title{Read Raven Custom Output files}
\usage{
rvn_custom_read(ff = NA, no_runname = FALSE, tzone = "UTC")
}
\arguments{
\item{ff}{full file path to the custom output file}

\item{no_runname}{boolean for whether a runName is supplied, important for
parsing the filename}

\item{tzone}{string indicating the timezone of the data in ff}
}
\value{
\item{custom_out}{data frame with the custom output data stored as xts
object}
}
\description{
rvn_custom_read is used to read any Raven custom output file
}
\details{
rvn_custom_read parses the filename and predicts the file format accordingly, so
it is important to use the unmodified file names for this function. The use
(or not) of a runname is accounted for.

The returned object is a time series object (xts format), which can be used
to easily plot the time series data. The options of the custom output are
included in the rav.obj attributes.

The timezone is provided by the tzone argument as "UTC" by default, and should be adjusted by
the user to the local time zone as needed, based on the model run.
}
\examples{

# find sample rvh file for Nith subwatershed
ff <- system.file("extdata","run1_SNOW_Daily_Average_ByHRU.csv", package="RavenR")

# extract and plot custom data
mycustomdata <- rvn_custom_read(ff)
summary(mycustomdata[,1:5])
plot(mycustomdata[,5],main='Daily Average SNOW - HRU 5')

}
\seealso{
\code{\link{rvn_custom_output_plot}} for plotting custom output
}
