% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duckhts.R
\name{setup_hts_env}
\alias{setup_hts_env}
\title{Setup HTSlib Environment}
\usage{
setup_hts_env(plugins_dir = NULL)
}
\arguments{
\item{plugins_dir}{Optional path to the htslib plugins directory. When NULL,
uses the bundled plugins directory if available.}
}
\value{
Invisibly returns the previous value of `HTS_PATH` (or `NA` if unset).
}
\description{
Sets the `HTS_PATH` environment variable to point to the bundled htslib
plugins directory. This enables remote file access via libcurl plugins
(e.g., s3://, gs://, http://) when plugins are available.
}
\details{
Call this before querying remote URLs to allow htslib to locate its plugins.
}
\examples{
\dontrun{
setup_hts_env()

plugins_path <- tempfile("hts_plugins_")
dir.create(plugins_path)
setup_hts_env(plugins_dir = plugins_path)
unlink(plugins_path, recursive = TRUE)
}
}
