set.seed(451)
data=rbind(matrix(runif(30,1,5), nrow = 3, ncol = 10),matrix(runif(20,20,30), nrow = 2, ncol = 10),matrix(runif(20,50,70), nrow = 2, ncol = 10))
k=3
seed=5

distance<- function(vect1, vect2){
  sqrt(sum((vect1-vect2)^2))
}

centers_function<-function(data, grouping){
  center=matrix(0,length(grouping), dim(data)[2])
 for (i in 1:(length(grouping))){

    if(length(grouping[[i]])==1){
      center[i,]=data[grouping[[i]],]
    }else{
     center[i,]=apply(data[grouping[[i]],],2,mean)
    }
  }
  return(center)
}

init_centers=init_centers_random

FHW_output=Hartigan_and_Wong(data, distance,k,centers_function,init_centers, seed=seed,10)



fin=max(c(distance( data[1,], data[4,]),
distance( data[1,], data[5,]),
distance( data[4,], data[5,])))


test_that("DistanceSameGroup", {
  expect_equal(DistanceSameGroup(1,  FHW_output, data, distance), fin,tolerance=1e-6)
})
