% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interim_MP.R, R/z_MPs.R
\name{make_interim_MP}
\alias{make_interim_MP}
\alias{make_projection_MP}
\alias{make_MP}
\title{Make a custom management procedure (MP)}
\usage{
make_interim_MP(
  .Assess = "SCA",
  .HCR = "HCR_MSY",
  AddInd = "VB",
  assessment_interval = 5,
  type = c("buffer", "mean", "loess", "none"),
  type_par = NULL,
  diagnostic = c("min", "full", "none"),
  ...
)

make_projection_MP(
  .Assess = "SCA",
  .HCR = "HCR_MSY",
  assessment_interval = 5,
  Ftarget = expression(Assessment@FMSY),
  proj_args = list(process_error = 1, p_sim = 1),
  diagnostic = c("min", "full", "none"),
  ...
)

make_MP(.Assess, .HCR, diagnostic = c("min", "full", "none"), ...)
}
\arguments{
\item{.Assess}{Assessment model, a function of class \code{Assess}.}

\item{.HCR}{Harvest control rule, a function of class \code{HCR}. Currently not used in projection MPs.}

\item{AddInd}{A vector of integers or character strings indicating the indices to be used in the assessment model.
Integers assign the index to the corresponding index in Data@AddInd, "B" (or 0) represents total biomass in Data@Ind,
"VB" represents vulnerable biomass in Data@VInd, and "SSB" represents spawning stock biomass in Data@SpInd. For the interim
procedure, the function will use the first index in \code{AddInd}.}

\item{assessment_interval}{The time interval for when the assessment model is applied (number of years). In all other years, the
interim procedure is applied.}

\item{type}{How the index is used to calculate the TAC in the interim procedure. See details.}

\item{type_par}{A control parameter for the interim procedure. See details.}

\item{diagnostic}{A character string describing if any additional diagnostic information from the
assessment models will be collected during the closed-loop simulation. \code{"min"} (minimal) will collect information
on convergence (default) and \code{"full"} will also collect the model estimates of biomass and F generated by \code{.Assess}.
\code{"none"} skips this step.}

\item{...}{Additional arguments to be passed to \code{.Assess} and \code{.HCR}.}

\item{Ftarget}{An expression that the MP will evaluate to identify the F used in the projection. See \link{projection} and example.}

\item{proj_args}{Additional arguments for \link{projection}.}
}
\value{
A function of class \code{MP}.
}
\description{
Function operator that creates a management procedure (MP) by combining an assessment model (function of class \code{Assess}) with
a harvest control rule (function of class \code{HCR}). The resulting function can then be tested in closed-loop simulation via
\code{\link[MSEtool:runMSE]{MSEtool::runMSE()}}.

\itemize{
\item Use \code{make_MP} to specify constant TAC between assessments; the frequency of
assessments is specified in \code{OM@interval}.
\item Use \code{make_projection_MP} to set catches according to a schedule set by projections,
specify assessment frequency in argument \code{assessment_interval} and ensure that \code{OM@interval <- 1}.
\item Use \code{make_interim_MP} to use an interim procedure to adjust the TAC between
assessments using an index (Huynh et al. 2020), with the frequency of assessments specified in argument \code{assessment_interval} when
making the MP; ensure that \code{OM@interval <- 1}.
}
}
\details{
\code{make_interim_MP} creates an MP that runs the interim procedure (updating the TAC according to index observations in between periodic
assessment intervals. \strong{Always ensure to set:} \code{OM@interval <- 1}. The assessment frequency is specified in argument
\code{assessment_interval}.

In the year when the assessment is applied, the TAC is set by fitting the model and then running the harvest control rule. Between assessments,
the TAC is updated as
\deqn{
\textrm{TAC}_{y+1} = C_{\textrm{ref}} (I_y + b \times s)/(I_{\textrm{ref}} + b \times s)
}
where \code{Cref} is the TAC calculated from the most recent assessment, \code{Iref} is the value of the index when \code{Cref} was calculated
(see Equations 6 and 7 of Huynh et al. 2020). The value of \code{I_y} depends on \code{type}, with \code{b} and \code{s} equal zero unless
\code{type = "buffer"}:

\itemize{
\item \code{"buffer"} - \code{I_y} is the most recent index with \code{b} is specifed by \code{type_par} (default = 1), and \code{s} is
the standard deviation of index residuals from the most recent assessment.
\item \code{"mean"} - \code{I_y} is the mean value of the index over the most recent \code{type_par} years (default = 3).
\item \code{"loess"} - \code{I_y} is the most recent index predicted by a \link[stats:loess]{loess} smoother applied over the entire time series of the index.
Use \code{type_par} to adjust the \code{span} parameter (default = 0.75).
\item \code{"none"} - \code{I_y} is the most recent index. Index values are not adjusted in the interim procedure.
}
}
\examples{
\donttest{
# Interim MPs
MP_buffer_5 <- make_interim_MP(assessment_interval = 5)
MP_buffer_10 <- make_interim_MP(assessment_interval = 10)
OM <- MSEtool::testOM
OM@interval <- 1

MSE <- MSEtool::runMSE(OM, MPs = c("MP_buffer_5", "MP_buffer_10")) 
}
# A statistical catch-at-age model with a 40-10 control rule
SCA_40_10 <- make_MP(SCA, HCR40_10)

# An SCA that will produce convergence diagnostics
SCA_40_10 <- make_MP(SCA, HCR40_10, diagnostic = "min")

# MP with an SCA that uses a Ricker stock-recruit function.
SCA_Ricker <- make_MP(SCA, HCR_MSY, SR = "Ricker")
show(SCA_Ricker)

\donttest{
# TAC is calculated annually from triennial assessments with projections between
# assessments with F = 0.75 FMSY
# Projections by default assume no process error.
OM <- MSEtool::testOM
OM@interval <- 1
pMP <- make_projection_MP(SCA, assessment_interval = 3, 
                          Ftarget = expression(0.75 * Assessment@FMSY),
                          proj_args = list(process_error = 1))
}

}
\references{
Huynh et al. 2020. The interim management procedure approach for assessed stocks: Responsive management advice and lower assessment
frequency. Fish Fish. 21:663–679. \doi{10.1111/faf.12453}
}
\seealso{
\link{HCR_ramp} \link{HCR_MSY} \link{diagnostic} \link{retrospective_AM}
}
