% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maximin.R
\name{maximin.remove}
\alias{maximin.remove}
\title{Sequentially remove design points from a design while maintaining low reciprocal distance criterion as possible}
\usage{
maximin.remove(D, n.remove, r = 2 * p)
}
\arguments{
\item{D}{the design matrix.}

\item{n.remove}{number of design points to remove.}

\item{r}{the power parameter in the \code{\link{maximin.crit}}. By default it is set as \code{2p}.}
}
\value{
the updated design.
}
\description{
This function sequentially removes design points one-at-a-time from a design while maintaining low reciprocal distance criterion as possible.
}
\details{
\code{maximin.remove} sequentially removes design points from a design in a greedy way while maintaining low reciprocal distance criterion (see \code{\link{maximin.crit}}) as possible. In each iteration, the design point with the largest sum of reciprocal distances with the other design points is removed, that is, \eqn{k^* = \arg\max_k \sum_{i\neq k}\frac{1}{\|\bm x_k - \bm x_i\|^r}}.
}
\examples{
# Example 1
n = 20
p = 3
n.remove =  5
D = maximinLHD(n, p)$design
D = maximin.remove(D, n.remove)

# Example 2 : generate maximin design from candidates
N = 500
n = 20
p = 2
candidates = matrix(runif(N*p), ncol=p)
D = maximin.remove(candidates, N-n)

}
