% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.SLOPE}
\alias{predict.SLOPE}
\alias{predict.GaussianSLOPE}
\alias{predict.BinomialSLOPE}
\alias{predict.PoissonSLOPE}
\alias{predict.MultinomialSLOPE}
\title{Generate Predictions from SLOPE Models}
\usage{
\method{predict}{SLOPE}(
  object,
  x,
  alpha = NULL,
  type = "link",
  simplify = TRUE,
  exact = FALSE,
  sigma,
  ...
)

\method{predict}{GaussianSLOPE}(
  object,
  x,
  sigma = NULL,
  type = c("link", "response"),
  simplify = TRUE,
  ...
)

\method{predict}{BinomialSLOPE}(
  object,
  x,
  sigma = NULL,
  type = c("link", "response", "class"),
  simplify = TRUE,
  ...
)

\method{predict}{PoissonSLOPE}(
  object,
  x,
  sigma = NULL,
  type = c("link", "response"),
  exact = FALSE,
  simplify = TRUE,
  ...
)

\method{predict}{MultinomialSLOPE}(
  object,
  x,
  sigma = NULL,
  type = c("link", "response", "class"),
  exact = FALSE,
  simplify = TRUE,
  ...
)
}
\arguments{
\item{object}{an object of class \code{"SLOPE"}, typically the result of
a call to \code{\link[=SLOPE]{SLOPE()}}}

\item{x}{new data}

\item{alpha}{penalty parameter for SLOPE models; if \code{NULL}, the
values used in the original fit will be used}

\item{type}{type of prediction; \code{"link"} returns the linear predictors,
\code{"response"} returns the result of applying the link function,
and \code{"class"} returns class predictions.}

\item{simplify}{if \code{TRUE}, \code{\link[base:drop]{base::drop()}} will be called before returning
the coefficients to drop extraneous dimensions}

\item{exact}{if \code{TRUE} and the given parameter values differ from those in
the original fit, the model will be refit by calling \code{\link[stats:update]{stats::update()}} on
the object with the new parameters. If \code{FALSE}, the predicted values
will be based on interpolated coefficients from the original
penalty path.}

\item{sigma}{deprecated. Please use \code{alpha} instead.}

\item{...}{ignored and only here for method consistency}
}
\value{
Predictions from the model with scale determined by \code{type}.
}
\description{
Return predictions from models fit by \code{\link[=SLOPE]{SLOPE()}}.
}
\examples{
fit <- with(mtcars, SLOPE(cbind(mpg, hp), vs, family = "binomial"))
predict(fit, with(mtcars, cbind(mpg, hp)), type = "class")
}
\seealso{
\code{\link[stats:predict]{stats::predict()}}, \code{\link[stats:predict.glm]{stats::predict.glm()}}

Other SLOPE-methods: 
\code{\link{coef.SLOPE}()},
\code{\link{deviance.SLOPE}()},
\code{\link{plot.SLOPE}()},
\code{\link{print.SLOPE}()},
\code{\link{score}()},
\code{\link{summary.SLOPE}()}
}
\concept{SLOPE-methods}
