% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{sm_plot_topic_trends}
\alias{sm_plot_topic_trends}
\title{Plot Topic Trends Over Time}
\usage{
sm_plot_topic_trends(
  model,
  dtm,
  metadata,
  doc_id_col = "doc_id",
  year_filter = NULL
)
}
\arguments{
\item{model}{A fitted topic model (LDA, STM, or CTM).}

\item{dtm}{The document-term matrix used to train the model.}

\item{metadata}{Data frame with a 'year' column and document identifiers.}

\item{doc_id_col}{Name of the document ID column in metadata.
Default is "doc_id".}

\item{year_filter}{Optional vector of years to include. Default is NULL
(includes all years).}
}
\value{
A ggplot object.
}
\description{
Creates a stacked percentage bar chart showing how topic proportions
change over publication years.
}
\examples{
\dontrun{
# Requires trained model and metadata
papers$doc_id <- paste0("doc_", seq_len(nrow(papers)))
lda_model <- sm_train_lda(dtm, k = 10)
sm_plot_topic_trends(lda_model, dtm, metadata = papers)
}
}
