% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_modeling.R
\name{sm_train_lda}
\alias{sm_train_lda}
\title{Train LDA Topic Model}
\usage{
sm_train_lda(
  dtm,
  k = NULL,
  method = "gibbs",
  seed = 1729,
  iter = 500,
  burnin = 100,
  alpha = NULL,
  beta = 0.1
)
}
\arguments{
\item{dtm}{A DocumentTermMatrix object.}

\item{k}{Number of topics. If NULL, will attempt to use sm_select_optimal_k
first. Default is NULL.}

\item{method}{Method for fitting. Options: "gibbs" or "vem".
Default is "gibbs".}

\item{seed}{Random seed for reproducibility. Default is 1729.}

\item{iter}{Number of Gibbs iterations (if method = "gibbs").
Default is 500.}

\item{burnin}{Number of burn-in iterations (if method = "gibbs").
Default is 100.}

\item{alpha}{Hyperparameter for document-topic distributions.
Default is 50/k (following Griffiths & Steyvers 2004).}

\item{beta}{Hyperparameter for topic-word distributions. Default is 0.1.}
}
\value{
An LDA_Gibbs or LDA_VEM object from the topicmodels package.
}
\description{
Fits a Latent Dirichlet Allocation (LDA) model to a document-term matrix.
}
\examples{
\dontrun{
# Requires document-term matrix from sm_create_dtm()
dtm <- sm_create_dtm(processed_data)
lda_model <- sm_train_lda(dtm, k = 10)
}
}
