% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_plot.R
\name{sc_plotnni}
\alias{sc_plotnni}
\title{Plot National Nutrient Inventory data for streams}
\usage{
sc_plotnni(comid, include.nue = FALSE, include.inset = TRUE)
}
\arguments{
\item{comid}{Identifier of stream COMID user wants to plot NNI data for. Must be a character string
with the COMID digit.
Syntax: com=<COMID>}

\item{include.nue}{Include time series of nitrogen use efficiency in the returned plot. 
The default value is false. 
Values: true|false}

\item{include.inset}{Include inset map that shows the location of the COMID and its basin. 
The default value is true. 
Values: true|false}
}
\value{
Return plot as an object.
}
\description{
Function to plot time series of nitrogen and phosphorus budgets for a given stream
COMID. This function allows a user to return a time series of major inputs, 
outputs, and derived metrics of nitrogen and phosphorus. Plot is returned as an 
object
}
\examples{
\dontrun{
p <- sc_plotnni(comid='1337420')
p <- sc_plotnni(comid='1337420', include.nue=TRUE)
p <- sc_plotnni(comid='1337420', include.inset=FALSE)
}
}
\author{
Selia Markley
}
