% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.surrogate.rise.R
\name{test.surrogate.rise}
\alias{test.surrogate.rise}
\title{Performs RISE: Two-Stage Rank-Based Identification of High-Dimensional Surrogate Markers}
\usage{
test.surrogate.rise(
  yone,
  yzero,
  sone,
  szero,
  alpha = 0.05,
  power.want.s = NULL,
  epsilon = NULL,
  u.y.hyp = NULL,
  p.correction = "BH",
  n.cores = 1,
  alternative = "less",
  paired = FALSE,
  screen.proportion = 0.66,
  return.all.screen = TRUE,
  return.all.evaluate = TRUE,
  return.plot.evaluate = TRUE,
  evaluate.weights = TRUE,
  return.all.weights = FALSE,
  weight.mode = "inverse.delta",
  normalise.weights = T
)
}
\arguments{
\item{yone}{numeric vector of primary response values in the treated group.}

\item{yzero}{numeric vector of primary response values in the untreated group.}

\item{sone}{matrix or dataframe of surrogate candidates in the treated group with
dimension \code{n1 x p} where n1 is the number of treated samples and p
the number of candidates. Sample ordering must match exactly yone.}

\item{szero}{matrix or dataframe of surrogate candidates in the untreated group with
dimension \code{n0 x p} where n0 is the number of untreated samples and p
the number of candidates. Sample ordering must match exactly yzero.}

\item{alpha}{significance level for determining surrogate candidates. Default is
\code{0.05}.}

\item{power.want.s}{numeric in (0,1) - power desired for a test of treatment effect based on
the surrogate candidate. Either this or \code{epsilon} argument must be
specified.}

\item{epsilon}{numeric in (0,1) - non-inferiority margin for determining surrogate
validity. Either this or \code{power.want.s} argument must be specified.}

\item{u.y.hyp}{hypothesised value of the treatment effect on the primary response on the
probability scale. If not given, it will be estimated based on the
observations.}

\item{p.correction}{character. Method for p-value adjustment (see \code{p.adjust()}
function). Defaults to the Benjamini-Hochberg method (\code{"BH"}).}

\item{n.cores}{numeric giving the number of cores to commit to parallel computation in
order to improve computational time through the \code{pbmcapply()}
function. Defaults to \code{1}.}

\item{alternative}{character giving the alternative hypothesis type. One of
\code{c("less","two.sided")}, where "less" corresponds to a
non-inferiority test and "two.sided" corresponds to a two one-sided test
procedure. Default is "less".}

\item{paired}{logical flag giving if the data is independent or paired. If
\code{FALSE} (default), samples are assumed independent. If \code{TRUE},
samples are assumed to be from a paired design. The pairs are specified
by matching the rows of \code{yone} and \code{sone} to the rows of
\code{yzero} and \code{szero}.}

\item{screen.proportion}{numeric in (0,1) - proportion of data to be used for the screening stage.
The default is \code{2/3}. If \code{1} is given, screening and evaluation
will be performed on the same data.}

\item{return.all.screen}{logical flag. If \code{TRUE} (default), a dataframe will be returned
giving the screening results for all candidates. Else, only the
significant candidates will be returned.}

\item{return.all.evaluate}{logical flag. If \code{TRUE} (default), a dataframe will be returned
giving the evaluation of each individual marker passed to the evaluation
stage.}

\item{return.plot.evaluate}{logical flag. If \code{TRUE} (default), a ggplot2 object will be
returned allowing the user to visualise the association between the
composite surrogate on the individual-scale.}

\item{evaluate.weights}{logical flag. If \code{TRUE} (default), the composite surrogate is
constructed with weights such that surrogates which are predicted to be
stronger receive more weight.}

\item{return.all.weights}{logical flag. If \code{FALSE} (default), a dataframe will be returned giving
weights for significant markers screened. If \code{TRUE}, weights for all markers will be returned. Note
that, if normalised weights are required, these will only be returned for significant markers, and raw
weights will be returned in a second column.}

\item{weight.mode}{character giving the type of weighting to return. One of \code{c("inverse.delta",}
\code{"diff.epsilon", or "none")}. The default is \code{"inverse.delta"}, which means
the weights are determined by taking the inverse of the absolute values of delta. If delta is exactly 0,
this is uncomputable and the weight defaults to the inverse of the next closest absolute delta value. If
delta is very close to 0, these estimates can be unstable and extreme. The \code{"diff.epsilon"} option
seeks to aid this by calculating weights as the proportion of the interval between 0 and epsilon cut by
the absolute value of delta, therefore giving delta = 0 a weight of 1 and delta = epsilon a weight of 0.
When \code{"none"}, the weights are set to 1 for every marker.}

\item{normalise.weights}{logical flag. If \code{TRUE} (default), the weights are normalised by the sum of
all the weights such that the maximum weight is 1, which can help with interpretability.}
}
\value{
a list with \itemize{
\item \code{screening.results}: a list with \itemize{
\item \code{screening.metrics} : dataframe of screening results (for each candidate marker - number of observations n,
u.y, u.s, delta, CI, sd, epsilon, p-values)
\item \code{significant_markers}: character vector of markers with \code{p_adjusted < alpha}.
}
\item \code{evaluate.results}: a list with \itemize{
\item \code{individual.metrics} if \code{return.all.evaluate}=\code{TRUE}, a dataframe of
evaluation results for each significant marker.
\item \code{gamma.s} a list with elements \code{gamma.s.one} and \code{gamma.s.zero}, giving the
combined surrogate marker in the treated and untreated groups, respectively.
\item \code{gamma.s.evaluate} : a dataframe giving the evaluation of \code{gamma.s}
\item \code{gamma.s.plot} : a ggplot2 plot showing \code{gamma.s} against the primary response
on the rank-scale.
}
}
}
\description{
RISE (Rank-Based Identification of High-Dimensional Surrogate Markers) is a two-stage
method to identify and evaluate high-dimensional surrogate candidates of a continuous response.

In the first stage (called screening), the high-dimensional candidates are screened one-by-one
to identify strong candidates. Strength of surrogacy is assessed through a rank-based measure of
the similarity in treatment effects on a candidate surrogate and the primary response. P-values
corresponding to hypothesis testing on this measure are corrected for the high number of
statistical tests performed.

In the second stage (called evaluation), candidates with an adjusted p-value below a given
significance level are evaluated by combining them into a single synthetic marker. The surrogacy
of this marker is then assessed with the univariate test as described before.

To avoid overfitting, the two stages are performed on separate data.
}
\examples{
# Load high-dimensional example data
data("example.data.highdim")
yone <- example.data.highdim$y1
yzero <- example.data.highdim$y0
sone <- example.data.highdim$s1
szero <- example.data.highdim$s0
\donttest{
rise.result <- test.surrogate.rise(yone, yzero, sone, szero, power.want.s = 0.8)}
}
\author{
Arthur Hughes
}
