% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighting.R
\name{weighted_mean}
\alias{weighted_mean}
\title{Calculate weighted mean}
\usage{
weighted_mean(data, target_col, weight_col)
}
\arguments{
\item{data}{A data.frame containing survey data}

\item{target_col}{Character string specifying column name for target variable}

\item{weight_col}{Character string specifying column name containing weights}
}
\value{
Numeric weighted mean
}
\description{
This function calculates the weighted mean of a numeric variable.
Uses standard weighted mean formula: sum(x * w) / sum(w)
}
\examples{
data <- data.frame(income = c(50000, 75000, 100000), weight = c(1.2, 0.8, 1.0))
weighted_income <- weighted_mean(data, "income", "weight")
}
