% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_gfm_data.R
\name{generate_gfm_data}
\alias{generate_gfm_data}
\title{Generate general factor model with smooth latent transformation}
\usage{
generate_gfm_data(n, p, m, g_fun, seed = 1, sigma_V = 0.1)
}
\arguments{
\item{n}{Integer: sample size.}

\item{p}{Integer: number of observed variables.}

\item{m}{Integer: number of latent factors (both layers).}

\item{g_fun}{Function: smooth, element-wise transformation applied to latent
factors.  Must be vectorised, e.g. `sin`, `tanh`, `scale`.}

\item{seed}{1.}

\item{sigma_V}{Numeric: standard deviation of the idiosyncratic noise
(default 0.1 => Var = 0.01).}
}
\value{
List with components
  X  : n * p matrix of standardised observations.
  A1 : p * m first-layer loading matrix.
  A2 : m * m second-layer loading matrix.
  Ag : p * m overall loading matrix (Ag = A1 %*% t(A2)).
  F1 : n * m latent factors (before transformation).
  gF1: n * m latent factors (after transformation).
  V1 : n * p noise matrix (for diagnostics).
}
\description{
Generate general factor model with smooth latent transformation
}
\examples{
dat <- generate_gfm_data(200, 50, 5, g_fun = tanh)
}
