% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{kneedle}
\alias{kneedle}
\alias{kneedle_increasing}
\title{Knee/Elbow Point Detection}
\usage{
kneedle_increasing(x, convex = TRUE, dt = 0.01)
}
\arguments{
\item{x}{data vector (increasing)}

\item{convex}{whether the data in \code{x} are convex-ish (elbow detection)
or not (knee lookup)}

\item{dt}{controls the smoothing parameter \eqn{\alpha = 1-\exp(-dt)}
of the exponential moving average,
\eqn{y_i = \alpha x_i + (1-\alpha) x_{i-1}}, \eqn{y_1 = x_1}}
}
\value{
Returns the index of the knee/elbow point; 1 if not found.
}
\description{
Finds the most significant knee/elbow using the Kneedle algorithm
with exponential smoothing.
}
\references{
V. Satopaa, J. Albrecht, D. Irwin, B. Raghavan,
Finding a "Kneedle" in a haystack: Detecting knee points in system behavior,
In: 31st Intl. Conf. Distributed Computing Systems Workshops,
2011, 166-171, \doi{10.1109/ICDCSW.2011.20}
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
\seealso{
The official online manual of \pkg{deadwood} at \url{https://deadwood.gagolewski.com/}

}
