% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdal_helpers.R
\name{get_pixel_line}
\alias{get_pixel_line}
\title{Raster pixel/line from geospatial x,y coordinates}
\usage{
get_pixel_line(xy, gt)
}
\arguments{
\item{xy}{Numeric matrix of geospatial x, y coordinates in the same spatial
reference system as \code{gt} (or two-column data frame that will be coerced
to numeric matrix, or a vector x, y for one coordinate).}

\item{gt}{Either a numeric vector of length six containing the affine
geotransform for the raster, or an object of class \code{GDALRaster} from
which the geotransform will be obtained (see Note).}
}
\value{
Integer matrix of raster pixel/line.
}
\description{
\code{get_pixel_line()} converts geospatial coordinates to pixel/line (raster
column, row numbers).
The upper left corner pixel is the raster origin (0,0) with column, row
increasing left to right, top to bottom.
}
\note{
This function applies the inverse geotransform to the input points. If \code{gt}
is given as the numeric vector, no bounds checking is done (i.e., min
pixel/line could be less than zero and max pixel/line could be greater than
the raster x/y size). If \code{gt} is obtained from an object of class
\code{GDALRaster}, then \code{NA} is returned for points that fall outside the
raster extent and a warning emitted giving the number points that were
outside. This latter case is equivalent to calling the
\code{$get_pixel_line()} class method on the \code{GDALRaster} object (see
Examples).
}
\examples{
pt_file <- system.file("extdata/storml_pts.csv", package="gdalraster")
# id, x, y in NAD83 / UTM zone 12N
pts <- read.csv(pt_file)
print(pts)

raster_file <- system.file("extdata/storm_lake.lcp", package="gdalraster")
ds <- new(GDALRaster, raster_file)
gt <- ds$getGeoTransform()
get_pixel_line(pts[, -1], gt)

# or, using the class method
ds$get_pixel_line(pts[, -1])

# add a point outside the raster extent
pts[11, ] <- c(11, 323318, 5105104)
get_pixel_line(pts[, -1], gt)

# with bounds checking on the raster extent
ds$get_pixel_line(pts[, -1])

ds$close()
}
\seealso{
\code{\link[=GDALRaster]{GDALRaster$getGeoTransform()}}, \code{\link[=inv_geotransform]{inv_geotransform()}}
}
