% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensors.R
\name{ggml_dup_tensor}
\alias{ggml_dup_tensor}
\title{Duplicate Tensor}
\usage{
ggml_dup_tensor(ctx, tensor)
}
\arguments{
\item{ctx}{GGML context}

\item{tensor}{Tensor to duplicate}
}
\value{
New tensor pointer with same shape
}
\description{
Creates a copy of a tensor with the same shape and type
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 100)
b <- ggml_dup_tensor(ctx, a)
ggml_nelements(b)
ggml_free(ctx)
}
}
