% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{ggml_init_auto}
\alias{ggml_init_auto}
\title{Create Context with Auto-sizing}
\usage{
ggml_init_auto(..., extra_mb = 10, type = GGML_TYPE_F32, no_alloc = FALSE)
}
\arguments{
\item{...}{Named arguments with tensor dimensions}

\item{extra_mb}{Extra megabytes to add (default: 10)}

\item{type}{Tensor type (default: GGML_TYPE_F32)}

\item{no_alloc}{If TRUE, don't allocate memory for tensors (default: FALSE)}
}
\value{
GGML context
}
\description{
Creates a context with automatically calculated size based on planned tensors
}
\examples{
\donttest{
# For two 1000x1000 matrices
ctx <- ggml_init_auto(mat1 = c(1000, 1000), mat2 = c(1000, 1000))
ggml_free(ctx)
}
}
