% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/big_neurovec.R
\name{BigNeuroVec}
\alias{BigNeuroVec}
\title{Create a Memory-Mapped Neuroimaging Vector}
\usage{
BigNeuroVec(
  data,
  space,
  mask,
  label = "",
  type = c("double", "float", "integer"),
  backingfile = tempfile()
)
}
\arguments{
\item{data}{The input data to be stored}

\item{space}{A NeuroSpace object defining the spatial properties}

\item{mask}{A logical mask indicating which voxels contain data}

\item{label}{Optional character string label for the vector}

\item{type}{Storage type, one of "double", "float", or "integer"}

\item{backingfile}{Path to the file used for memory mapping (defaults to tempfile())}
}
\value{
A new BigNeuroVec object that provides memory-efficient access to large neuroimaging data through memory mapping.
        The object contains the spatial properties, mask, and memory-mapped data storage.
}
\description{
Creates a BigNeuroVec object, which represents a large neuroimaging vector using
memory-mapped file storage. This allows working with neuroimaging data that is
too large to fit in memory.
}
\examples{
\donttest{
# Load an example 4D brain image
example_file <- system.file("extdata", "global_mask_v4.nii", package = "neuroim2")
example_4d_image <- read_vec(example_file)

# Create a mask (e.g., selecting voxels with values > 0)
mask <- array(as.vector(example_4d_image[,,,1]) > 0,
             dim = dim(example_4d_image)[1:3])

if(requireNamespace("bigstatsr", quietly = TRUE)) {
  # Create a BigNeuroVec with memory mapping
  big_vec <- BigNeuroVec(data = example_4d_image@.Data,
                         space = space(example_4d_image),
                         mask = mask,
                         label = "Example BigNeuroVec")
  print(big_vec)
}
}

}
