% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_as_df.R
\name{data.frame_export}
\alias{data.frame_export}
\alias{as_result_df}
\alias{path_enriched_df}
\title{Generate a result data frame}
\usage{
as_result_df(
  tt,
  spec = NULL,
  data_format = c("full_precision", "strings", "numeric"),
  make_ard = FALSE,
  expand_colnames = FALSE,
  keep_label_rows = FALSE,
  add_tbl_name_split = FALSE,
  simplify = FALSE,
  verbose = FALSE,
  ...
)

path_enriched_df(tt, path_fun = collapse_path, value_fun = collapse_values)
}
\arguments{
\item{tt}{(\code{TableTree} or related class)\cr a \code{TableTree} object representing a populated table.}

\item{spec}{(\code{function})\cr function that generates the result data frame from a table (\code{TableTree}).
It defaults to \code{NULL}, for standard processing.}

\item{data_format}{(\code{string})\cr the format of the data in the result data frame. It can be one value
between \code{"full_precision"} (default), \code{"strings"}, and \code{"numeric"}. The last two values show the numeric
data with the visible precision.}

\item{make_ard}{(\code{flag})\cr when \code{TRUE}, the result data frame will have only one statistic per row.}

\item{expand_colnames}{(\code{flag})\cr when \code{TRUE}, the result data frame will have expanded column
names above the usual output. This is useful when the result data frame is used for further processing.}

\item{keep_label_rows}{(\code{flag})\cr when \code{TRUE}, the result data frame will have all labels
as they appear in the final table.}

\item{add_tbl_name_split}{(\code{flag})\cr when \code{TRUE} and when the table has more than one
\code{analyze(table_names = "<diff_names>")}, the table names will be present as a group split named
\code{"<analysis_spl_tbl_name>"}.}

\item{simplify}{(\code{flag})\cr when \code{TRUE}, the result data frame will have only visible labels and
result columns. Consider showing also label rows with \code{keep_label_rows = TRUE}. This output can be
used again to create a \code{TableTree} object with \code{\link[=df_to_tt]{df_to_tt()}}.}

\item{verbose}{(\code{flag})\cr when \code{TRUE}, the function will print additional information for
\code{data_format != "full_precision"}.}

\item{...}{additional arguments passed to spec-specific result data frame function (\code{spec}). When
using \code{make_ard = TRUE}, it is possible to turn off the extraction of the exact string decimals
printed by the table with \code{add_tbl_str_decimals = FALSE}.}

\item{path_fun}{(\code{function})\cr function to transform paths into single-string row/column names.}

\item{value_fun}{(\code{function})\cr function to transform cell values into cells of a \code{data.frame}. Defaults to
\code{collapse_values}, which creates strings where multi-valued cells are collapsed together, separated by \code{|}.}
}
\value{
\itemize{
\item \code{as_result_df} returns a result \code{data.frame}.
}

\itemize{
\item \code{path_enriched_df()} returns a \code{data.frame} of \code{tt}'s cell values (processed by \code{value_fun}, with columns named by
the full column paths (processed by \code{path_fun} and an additional \code{row_path} column with the row paths (processed
by \code{path_fun}).
}
}
\description{
Collection of utilities to extract \code{data.frame} objects from \code{TableTree} objects.
}
\section{Functions}{
\itemize{
\item \code{path_enriched_df()}: Transform a \code{TableTree} object to a path-enriched \code{data.frame}.

}}
\note{
When \code{parent_name} is used when constructing a layout to directly control
the name of subtables in a table, that will be reflected in the 'group' values
returned in the result dataframe/ard. When automatic de-duplication of sibling names
is performed by \code{rtables}, that is automatically undone during the result
df creation process, so the group values will be as if the relevant siblings
had identical names.
}
\examples{
lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("STRATA1") \%>\%
  analyze(c("AGE", "BMRKR2"))

tbl <- build_table(lyt, ex_adsl)
as_result_df(tbl, simplify = TRUE)

lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  analyze(c("AGE", "BMRKR2"))

tbl <- build_table(lyt, ex_adsl)
path_enriched_df(tbl)

}
\seealso{
\code{\link[=df_to_tt]{df_to_tt()}} when using \code{simplify = TRUE} and \code{\link[formatters:make_row_df]{formatters::make_row_df()}} to have a
comprehensive view of the hierarchical structure of the rows.
}
