% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlp_melt_tokens.R
\name{nlp_melt_tokens}
\alias{nlp_melt_tokens}
\title{Tokenize Data Frame by Specified Column(s)}
\usage{
nlp_melt_tokens(
  df,
  melt_col = "token",
  parent_cols = c("doc_id", "sentence_id")
)
}
\arguments{
\item{df}{A data frame containing the data to be tokenized.}

\item{melt_col}{The name of the column in `df` that contains the tokens.}

\item{parent_cols}{A character vector indicating the column(s) by which to group the data.}
}
\value{
A list of vectors, each containing the tokens of a group defined by the `by` parameter.
}
\description{
This function tokenizes a data frame based on a specified token column and groups the data by one or more specified columns.
}
\examples{
dtm <- data.frame(doc_id = as.character(c(1, 1, 1, 1, 1, 1, 1, 1)),
                  sentence_id = as.character(c(1, 1, 1, 2, 2, 2, 2, 2)),
                  token = c("Hello", "world", ".", "This", "is", "an", "example", "."))

tokens <- nlp_melt_tokens(dtm, melt_col = 'token', parent_cols = c('doc_id', 'sentence_id'))


}
