% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StaggeredRecruiter.R
\name{StaggeredRecruiter}
\alias{StaggeredRecruiter}
\title{Generate Enrollment Time from Piecewise Constant Uniform Distribution}
\usage{
StaggeredRecruiter(n, accrual_rate)
}
\arguments{
\item{n}{integer. Number of random numbers.}

\item{accrual_rate}{a data frame of columns
\describe{
      \item{\code{end_time}}{
          End time for a constant rate in a time window. The start time of
          the first time window is 0.}
      \item{\code{piecewise_rate}}{
          A constant rate in a time window. So the number of patients
          being recruited in that window is window length x
          \code{piecewise_rate}. }
}}
}
\description{
It assumes a uniform enrollment with constant rate in each of the time
windows. This function can be used as the \code{enroller} when calling
\code{trial()} to define a trial.
}
\examples{
accrual_rate <- data.frame(
  end_time = c(12, 13:17, Inf),
  piecewise_rate = c(15, 15 + 6 * (1:5), 45)
)

StaggeredRecruiter(30, accrual_rate)

accrual_rate <- data.frame(
  end_time = c(3, 4, 5, 8, Inf),
  piecewise_rate = c(1, 2, 2, 3, 4)
)

StaggeredRecruiter(30, accrual_rate)
}
