% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETSmodel.R
\name{ETSsetup}
\alias{ETSsetup}
\title{ETSsetup}
\usage{
ETSsetup(
  y,
  u = NULL,
  model = "???",
  s = frequency(y),
  h = 2 * s,
  criterion = "aicc",
  lambda = 1,
  armaIdent = FALSE,
  identAll = FALSE,
  forIntervals = FALSE,
  bootstrap = FALSE,
  nSimul = 5000,
  verbose = FALSE,
  alphaL = c(1e-08, 1 - 1e-08),
  betaL = alphaL,
  gammaL = alphaL,
  phiL = c(0.8, 0.98),
  p0 = -99999
)
}
\arguments{
\item{y}{a time series to forecast (it may be either a numerical vector or
a time series object). This is the only input required. If a vector, the additional
input \code{s} should be supplied compulsorily (see below).}

\item{u}{a matrix of input time series. If 
the output wanted to be forecast, matrix \code{u} should contain future values for inputs.}

\item{model}{the model to estimate. It is a single string indicating the type of 
model for each component with one or two letters:
\itemize{
\item Error: ? / A / M

\item Trend: ? / N / A / Ad / M / Md 

\item Seasonal: ? / N / A / M

}}

\item{s}{seasonal period of time series (1 for annual, 4 for quarterly, ...)}

\item{h}{forecast horizon. If the model includes inputs h is not used, the lenght of u is used instead.}

\item{criterion}{information criterion for identification ("aic", "bic" or "aicc").}

\item{lambda}{Box-Cox lambda parameter (NULL: estimate)}

\item{armaIdent}{check for arma models for error component (TRUE / FALSE).}

\item{identAll}{run all models to identify the best one (TRUE / FALSE)}

\item{forIntervals}{estimate forecasting intervals (TRUE / FALSE)}

\item{bootstrap}{use bootstrap simulation for predictive distributions}

\item{nSimul}{number of simulation runs for bootstrap simulation of predictive distributions}

\item{verbose}{intermediate estimation output (TRUE / FALSE)}

\item{alphaL}{constraints limits for alpha parameter}

\item{betaL}{constraints limits for beta parameter}

\item{gammaL}{constraints limits for gamma parameter}

\item{phiL}{constraints limits for phi parameter}

\item{p0}{initial values for parameter search (alpha, beta, phi, gamma) with consraints:
\itemize{ 
\item 0 < alpha < 1

\item 0 < beta < alpha

\item 0 < phi < 1

\item 0 < gamma < 1 - alpha
}}
}
\value{
An object of class \code{ETS}. It is a list with fields including all the inputs and
        the fields listed below as outputs. All the functions in this package fill in
        part of the fields of any \code{ETS} object as specified in what follows (function 
        \code{ETS} fills in all of them at once):

After running \code{ETSforecast}:
\item{p}{Estimated parameters}
\item{criteria}{Values for estimation criteria (LogLik, AIC, BIC, AICc)}
\item{yFor}{Forecasted values of output}
\item{yForV}{Variance of forecasted values of output}
\item{ySimul}{Bootstrap simulations for forecasting distribution evaluation}

After running \code{ETSvalidate}:
\item{table}{Estimation and validation table}
\item{comp}{Estimated components in matrix form}

After running \code{ETScomponents}:
\item{comp}{Estimated components in matrix form}

An object of class \code{ETS}. See \code{ETSforecast}.
}
\description{
Sets up ETS general univariate models
}
\details{
See help of \code{ETSforecast}.
}
\examples{
\donttest{
y <- log(AirPassengers)
m1 <- ETSsetup(y)
m1 <- ETSsetup(y,  model = "???")
m1 <- ETSsetup(y,  model = "?AA")
}
}
\seealso{
\code{\link{ETS}}, \code{\link{ETSforecast}}, \code{\link{ETSvalidate}},
         \code{\link{ETScomponents}}
}
\author{
Diego J. Pedregal
}
