% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WIPF2.R
\name{WIPF2}
\alias{WIPF2}
\title{Weighted Iterative Proportional Fitting (WIPF) in two dimensions}
\usage{
WIPF2(
  seed,
  weights,
  margin1,
  margin2,
  normalize = TRUE,
  tol = 10^-6,
  maxit = 1000,
  full = FALSE,
  ...
)
}
\arguments{
\item{seed}{A (RxC) matrix of non-negative values with the initial values.}

\item{weights}{A (RxC) matrix of non-negative values with the weights associated to each entry of the matrix.}

\item{margin1}{A R-length vector of positive values with the target (weighted) marginal sums across columns to be fitted.}

\item{margin2}{A C-length vector of positive values with the target (weighted) marginal sums across rows to be fitted.}

\item{normalize}{\code{TRUE}/\code{FALSE} argument indicating whether the weights should be normalized
(across all dimensions, for either row or column weights to sum 1)  before constructing
the weighted sums for comparison with the margin values. Default, \code{TRUE}. Normalization is essential when adjusting
a set of indexes where the margins represent theoretical convex combinations of the inner indexes.
This characterizes a typical context where WIPF could be of value.}

\item{tol}{Stopping criterion. The algorithm stops when the maximum difference between the weighted sum(s) of
the values to be fitted and the margin(s) is lower than the value specified by \code{tol}.
Default, \code{0.000001}.}

\item{maxit}{Stopping criterion. A positive integer number indicating the maximum number of iterations
allowed. Default, \code{1000}. The algorithm will stop if the values to be fitted still has not
converged after this many iterations.}

\item{full}{\code{TRUE}/\code{FALSE} argument indicating if either only the solution should be shown or
a more complete output.}

\item{...}{Other arguments to be passed to the function. Not currently used.}
}
\value{
When \code{full = FALSE} an object similar to \code{seed} with the solution reached when the algorithm stops.
When \code{full = TRUE} a list with the following components:
\item{sol}{ An object similar to \code{seed} with the solution reached at convergence (or when the maximum number of iterations is reached).}
\item{iter}{ Number of iterations when the algorithm stops.}
\item{dev.margins}{ A list with a set of objects similar to the margins with absolute maximum deviations
between the values in margins and the corresponding weighted sums of the values in \code{sol}.}
\item{margin1}{ A R-length vector of positive values with the actual margin1 object used to reach the solution.
This coincides with \code{margin1} even when all the margins are not compatible given the weights.}
\item{margin2}{ A C-length vector of positive values with the actual margin2 object used to reach the solution.
This coincides with \code{margin2} when all the margins are compatible given the weights.}
\item{inputs}{ A list containing all the objects with the values used as arguments by the function.}
}
\description{
Implements WIPF in two dimensions. This function updates an initial
2-dimensional array (a matrix, referred to as the seed) using a matrix
of weights to align with a set of two vectors (referred to as the margins),
where one of them can be missing. When \code{margin1} and \code{margin2} are compatible
given the weights, the updated values ensure that the weighted sum
across columns matches \code{margin1} and the weighted sum across rows
matches \code{margin2}.
If the margins are incompatible given the weights, the function \code{WIPF1}
is applied to the initial margins to make them compatible. In those cases,
margins are updated (are made compatible) in increasing order of sub-indices
(i.e., \code{margin2} is adjusted to make it compatible with \code{margin1}).
}
\note{
Weighted Iterative proportional fitting is an extension of IPF.
WIPF produces the same solutions than IPF with all weights being ones
and when they are not normalized. IPF is also known as RAS in economics,
raking in survey research or matrix scaling in computer science.
}
\examples{
s <- structure(c(1.1279, 1.1304, 1.0304, 0.8554, 1.5606, 1.4171, 1.2862,
                 1.2472, 1.0746, 1.0796, 0.9806, 0.928, 1.1607, 1.2436, 1.2191,
                 1.0786, 1.0194, 1.1716, 0.9937, 0.8611, 1.0172, 1.2511, 1.1606,
                 1.1959), .Dim = c(4L, 6L))
w <- structure(c(72161.97, 93725.94, 84408.83, 172774.13, 52875.08,
                 31936.92, 14191.44, 12595.46, 291698.94, 231408.32,
                 221763.43, 235217.74, 42028.56, 64458.09, 93443.13,
                 60348.74, 222482.04, 103695.94, 57066.82, 48657.48,
                 9572.75, 75745.02, 83912.38, 94019.92), .Dim = c(4L, 6L))
m1 <- c(1.110737, 1.029947, 0.934799, 0.906475)
m2 <- c(0.810992, 1.375921, 1.071519, 1.045006, 0.949938, 0.915762)
example <- WIPF2(seed = s, weights = w, margin1 = m1, margin2 = m2, full = TRUE)

}
\author{
Jose M. Pavia, \email{pavia@uv.es}
}
