% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway_enrichment_sc.R
\name{categorized_enrich_sc}
\alias{categorized_enrich_sc}
\title{Perform Pathway Enrichment Analysis for Pre-Categorized Differentially Expressed Genes (DEGs)}
\usage{
categorized_enrich_sc(
  DEGs_category,
  enrichment_db = "KEGG",
  organism = "hsa",
  org_db = org.Hs.eg.db::org.Hs.eg.db,
  pvalueCutoff = 0.05,
  qvalueCutoff = 0.2
)
}
\arguments{
\item{DEGs_category}{Data frame containing gene symbols and their corresponding DEG types.
Must include columns 'DEG_Type' (DEGs categories) and 'Gene_Symbols'.}

\item{enrichment_db}{Character string specifying the enrichment database to use:
"KEGG", "GO", or "REACTOME" (default: "KEGG").}

\item{organism}{Character string representing the organism code. For KEGG enrichment,
use "hsa" (default). For Reactome enrichment, use "human".}

\item{org_db}{databse of the organism (e.g: Org.Hs.eg.db)}

\item{pvalueCutoff}{Numeric value specifying the p-value cutoff for statistical significance
(default: 0.05).}

\item{qvalueCutoff}{Numeric value specifying the q-value cutoff for multiple testing correction
(default: 0.2).}
}
\value{
A named list of enriched pathways for each DEG category, structured as a data frame.
}
\description{
This function performs pathway enrichment analysis for differentially expressed genes (DEGs),
which are already categorized into different types (e.g., Dimorphic, Neutral, Sex-specific) via
the `categorize_sex_sc` function. The function analyzes their enrichment in KEGG, GO, or Reactome pathways.
}
\details{
- The input DEGs are already categorized by the `categorize_sex_sc` function.
- For GO enrichment, an appropriate OrgDb object (e.g., org.Hs.eg.db for humans) must be available.
- For KEGG and Reactome enrichment, gene symbols are first converted to ENTREZ IDs.
- Requires the 'clusterProfiler' package for enrichment analysis.
- Ensures appropriate error handling for missing genes or database issues.
}
