% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghg_flux.R
\name{calculate_ghg_flux}
\alias{calculate_ghg_flux}
\title{calculate_ghg_flux}
\usage{
calculate_ghg_flux(
  data,
  slope = "slope",
  area = "area",
  volume = "volume",
  temp = "temp"
)
}
\arguments{
\item{data}{A data frame containing relevant data with columns for slope, area, volume, and temperature.}

\item{slope}{Name of the column in `data` that contains the slope values of the GHG concentration change (in ppm/s).}

\item{area}{Name of the column in `data` that contains the values of the area of the chamber (in square meter).}

\item{volume}{Name of the column in `data` that contains values of the volume of the chamber (in litre).}

\item{temp}{Name of the column in `data` that contains values of the temperature of the gas (in Celsius).}
}
\value{
A list containing the calculated flux and its unit.
}
\description{
Calculate the greenhouse gas (GHG) flux based on input parameters from a data frame.
}
\examples{
data <- data.frame(
  slope = c(1.2, 1.5, 1.1),
  area = c(100, 150, 120),
  volume = c(10, 15, 12),
  temp = c(25, 30, 22)
)
results <- calculate_ghg_flux(data)
print(results)
}
