% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghg_flux.R
\name{convert_ghg_unit}
\alias{convert_ghg_unit}
\title{convert_ghg_unit}
\usage{
convert_ghg_unit(
  input,
  ghg,
  mass = "µg",
  area = "m2",
  time = "hr",
  digits = 2,
  ratio = FALSE
)
}
\arguments{
\item{input}{A single numeric value or a character string containing one or
more numbers.}

\item{ghg}{The molecular formula of the greenhouse gas: \code{"co2"},
\code{"ch4"}, or \code{"n2o"}.}

\item{mass}{Mass unit of the input flux. One of \code{"mmol"}, \code{"mg"},
\code{"g"}, \code{"ug"} (micrograms), \code{"nmol"}, \code{"Mg"},
\code{"umol"} (micromoles), \code{"mol"}. Default \code{"ug"}.}

\item{area}{Area unit of the input flux. One of \code{"ha"}, \code{"m2"}.
Default \code{"m2"}.}

\item{time}{Time unit of the input flux. One of \code{"yr"}, \code{"day"},
\code{"hr"}, \code{"sec"}, \code{"min"}. Default \code{"hr"}.}

\item{digits}{Number of decimal places to round to. Default 2.}

\item{ratio}{Logical. If \code{TRUE}, apply an elemental-ratio correction
(C-basis for CH4, N-basis for N2O). Default \code{FALSE}.}
}
\value{
A named list with \code{value} (converted string) and \code{unit},
  or \code{"EMPTY"} for missing/non-numeric input.
}
\description{
Convert a greenhouse gas (GHG) flux value (or a character string
  containing one or more numeric values, e.g. \code{"0.002 +/- 0.003"})
  to micrograms per square meter per hour.
}
\details{
Numeric values embedded in a string (e.g. mean +/- SD notation)
  are each converted individually and the surrounding text is preserved.
  Commas are treated as decimal separators.
}
\examples{
convert_ghg_unit(97, ghg = "ch4", mass = "mg", area = "m2", time = "hr")
}
