% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_plane.r
\name{as_plane3d}
\alias{as_plane3d}
\alias{as_plane3d.numeric}
\alias{as_plane3d.character}
\alias{as_plane3d.Coord3D}
\alias{as_plane3d.Plane3D}
\alias{as_plane3d.Point1D}
\alias{as_plane3d.Line2D}
\title{Cast to Plane3D object}
\usage{
as_plane3d(...)

\method{as_plane3d}{numeric}(a, b, c, d, ...)

\method{as_plane3d}{character}(x, ...)

\method{as_plane3d}{Coord3D}(normal, p1 = as_coord3d("origin"), p2, p3, ...)

\method{as_plane3d}{Plane3D}(plane, ...)

\method{as_plane3d}{Point1D}(point, b = 0, c = 0, ...)

\method{as_plane3d}{Line2D}(line, c = 0, ...)
}
\arguments{
\item{...}{Passed to other function such as \code{as_coord2d()}.}

\item{a, b, c, d}{Numeric vectors that parameterize the plane via the equation \code{a * x + b * y + c * z + d = 0}.}

\item{x}{A (character) vector to be cast to a \link{Plane3D} object}

\item{normal}{Normal vector to the plane represented by a \link{Coord3D} class object. \code{p2} and \code{p3} should be missing.}

\item{p1}{Point on the plane represented by a \link{Coord3D} class object.}

\item{p2, p3}{Points on the plane represented by \link{Coord3D} class objects.  \code{normal} should be missing.}

\item{plane}{A \link{Plane3D} object}

\item{point}{A \link{Point1D} object}

\item{line}{A \link{Line2D} object}
}
\description{
\code{as_plane3d()} casts to a \link{Plane3D} object.
}
