% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LQRFE_main.R
\name{plot_taus}
\alias{plot_taus}
\title{plot multiple penalized quantile regression}
\usage{
plot_taus(
  Beta,
  tau = 1:9/10,
  D,
  col = 2,
  lwd = 1,
  lty = 2,
  pch = 1,
  cex.axis = 1,
  cex.lab = 1,
  main = ""
)
}
\arguments{
\item{Beta}{Numeric array, with three dimmensions: 1) tau, 2) coef., lower bound, upper bound, 3) exploratory variables.}

\item{tau}{Numeric vector, identifies the percentiles.}

\item{D}{covariate's number.}

\item{col}{color.}

\item{lwd}{line width.}

\item{lty}{line type.}

\item{pch}{point character.}

\item{cex.axis}{cex axis length.}

\item{cex.lab}{cex axis length.}

\item{main}{title.}
}
\description{
plot QR for several taus
}
\examples{
n = 10
m = 5
d = 4
N = n*m
L = N*d
x = matrix(rnorm(L), ncol=d, nrow=N)
subj = rep(1:n, each=m)
alpha = rnorm(n)
beta = rnorm(d)
eps = rnorm(N)
y = x \%*\% beta  + matrix(rep(alpha, each=m) + eps)
y = as.vector(y)

Beta = mqr(x,y,subj,tau=1:9/10, method="qr", ngrid = 10)
plot_taus(Beta,tau=1:9/10,D=1)

}
