% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulate_spacetime_data.R
\name{dt_as_mysftime}
\alias{dt_as_mysftime}
\title{Convert a \code{data.table} to an \code{sftime}}
\usage{
dt_as_mysftime(x, lonname, latname, timename, crs)
}
\arguments{
\item{x}{a \code{data.table}}

\item{lonname}{character for longitude column name}

\item{latname}{character for latitude column name}

\item{timename}{character for time column name}

\item{crs}{coordinate reference system}
}
\value{
an \code{sftime} object
}
\description{
Convert a \code{data.table} object to an \code{sftime}. \code{x} must be
a \code{data.table} object with "lon", "lat", and "time" columns to
describe the longitude, latitude, and time-orientation, respectively, of
\code{x}.
}
\author{
Eva Marques
}
\keyword{spacetime}
