% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PeriodicFunctions.R
\name{fit_LM_periodic_trawl}
\alias{fit_LM_periodic_trawl}
\title{Fits a supGamma periodic trawl function to equidistant time series data}
\usage{
fit_LM_periodic_trawl(
  x,
  m = 1,
  tau,
  GMMlag = 50,
  Delta = 1,
  plotacf = FALSE,
  lags = 100
)
}
\arguments{
\item{x}{vector of equidistant time series data}

\item{m}{the order of the Fourier approximation of the periodic function}

\item{tau}{the period, if not provided it will be estimated}

\item{GMMlag}{lag length used in the GMM estimation, the default is 50}

\item{Delta}{interval length of the time grid used in the time series, the
default is 1}

\item{plotacf}{binary variable specifying whether or not the empirical and
fitted autocorrelation function should be plotted}

\item{lags}{number of lags to be used in the plot of the autocorrelation
function}
}
\value{
alpha: the parameter \eqn{\alpha} in the supGamma trawl,
H: the parameter \eqn{H} in the supGamma trawl,
tau: the period \eqn{\tau}, a: the vector of the Fourier coefficients,
b: the vector of the Fourier coefficients.
}
\description{
Fits a supGamma periodic trawl function to equidistant time series data
}
\details{
The trawl function is parametrised by the parameter \eqn{\lambda > 0}
 as follows: \deqn{g(x) = (1+x/\alpha)^H,  \mbox{ for }  x \le 0.}
 The parameter \eqn{\tau} is estimated using the smoothed periodogram,
 the other parameters are estimated by GMM.
}
