% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries_enhanced.R
\name{anki_workload_projection}
\alias{anki_workload_projection}
\title{Workload Projection (Rough Estimate)}
\usage{
anki_workload_projection(
  path = NULL,
  profile = NULL,
  days = 30,
  scenarios = NULL
)
}
\arguments{
\item{path}{Path to collection.anki2 (auto-detected if NULL)}

\item{profile}{Profile name (first profile if NULL)}

\item{days}{Number of days to project (default 30)}

\item{scenarios}{List of scenario parameters}
}
\value{
A tibble with workload projections for each scenario
}
\description{
Project future review workload with scenario analysis. This provides rough
ballpark estimates for planning purposes, not accurate FSRS simulation.
}
\details{
This function uses simplified heuristics to estimate workload:
\itemize{
\item New cards reviewed ~4x during learning phase
\item Mature card reviews based on recent average
\item Retention affects review frequency
}

For accurate FSRS simulation, use Anki's built-in simulator (Tools > FSRS >
Simulate) or the FSRS Helper add-on, which implement the full FSRS algorithm.

This function is useful for:
\itemize{
\item Quick "what if" scenario comparisons
\item Rough planning estimates
\item Programmatic analysis in R
}
}
\examples{
\dontrun{
proj <- anki_workload_projection(days = 30)
}
}
