% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.R
\name{hz_lag}
\alias{hz_lag}
\title{Find lagged horizon values}
\usage{
hz_lag(
  object,
  lag = 1,
  unit = "index",
  idcol = "id",
  depthcols = c("top", "bottom"),
  order = FALSE
)
}
\arguments{
\item{object}{a \code{data.frame}}

\item{lag}{integer: number of horizons to lag}

\item{unit}{character: lag units in index or depth.}

\item{idcol}{character: column name of the pedon ID within the object.}

\item{depthcols}{a character vector of length 2 specifying the names of the horizon depths (e.g. \code{c("top", "bottom")}).}

\item{order}{logical: indicating whether or not to order the #'}
}
\value{
A \code{data.frame} with lagged values.
}
\description{
This function finds adjacent values to a horizon values at lagged distances.
}
\details{
.
}
\examples{

h <- data.frame(
  id = 1,
  top    = c(0,  25, 44, 46, 50),
  bottom = c(25, 44, 46, 50, 100),
  texcl     = c("SL", "SL", "CL", "CL", "L"),
  clay   = c(10, 12, 27, 35, 16)
)

hz_lag(h)

hz_lag(h, -1)

hz_lag(h, 10:15, unit = "depth")

transform(cbind(h, lag = hz_lag(h)), 
  clay_dif = lag.clay_bot.1 - clay,
  texcl_contrast = paste0(texcl, "-", lag.texcl_bot.1)
)

}
\seealso{
\code{\link[=hz_dissolve]{hz_dissolve()}}, \code{\link[=hz_intersect]{hz_intersect()}}, \code{\link[=hz_segment]{hz_segment()}}
}
\author{
Stephen Roecker
}
