% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth.R
\name{mbw}
\alias{mbw}
\title{Metabolic bodyweight (MBW)}
\usage{
mbw(ibw, fbw, mb_exp = 0.8)
}
\arguments{
\item{ibw}{a numeric value that is providing the initial weight in
grams.}

\item{fbw}{a numeric value that is providing the final weight in
grams.}

\item{mb_exp}{a numeric value between 0-1 providing the exponent. Default
is 0.8 adapted to most fish species.}
}
\value{
returns a numeric value that is the metabolic bodyweight.
}
\description{
The metabolic bodyweight is the rate of energy expenditure in dependence of
the bodyweight of an organism. The metabolism of larger animals is generally
slower per Kg when comparing with smaller animals. An exponent between 0-1
takes that relationship into account in a fairly simple equation.
}
\details{
The default exponent is suited to fish only. It was set to 0.8 based on
Lupatsch et al. (2003) and should be adjusted to other scenarios.
}
\examples{
data(weight2)
dplyr::mutate(weight2, MBW = mbw(ibw_g, fbw_g))

}
\references{
Lupatsch, I. et al. (2003): Comparison of energy and protein
efficiency among three fish species gilthead sea bream (Sparus aurata),
European sea bass (Dicentrarchus labrax) and white grouper (Epinephelus
aeneus): energy expenditure for protein and lipid deposition. Aquaculture
225, p.175-189.
}
\author{
Anıl Axel Tellbüscher

Davide A. Machado e Silva

Madhav Karthikeyan
}
