% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ards.R
\docType{package}
\name{ards}
\alias{ards}
\alias{ards-package}
\title{ards: A package for creating Analysis Results Datasets}
\description{
An Analysis Results Dataset (ARDS) is commonly used in the pharma-biotech industry
to capture the results of an analysis in a tabular data structure.  The \strong{ards}
package helps create the ARDS. \strong{ards} functions can be called from inside 
a report program or a data preparation program.  The functions use a 
"bucketing" approach, whereby data can be added to the ARDS in multiple 
calls and from multiple intermediate data sets.
}
\details{
The \strong{ards} package allows you to easily create an ARDS dataset
in a standard clinical reporting or data preparation program.  The 
\strong{ards} package contains only three functions, and each will
be used to create the ARDS dataset.  The functions will be called in the 
following order, and for the described purpose:
\itemize{
  \item \code{\link{init_ards}}: Initialize an ARDS dataset
  \item \code{\link{add_ards}}: Add data to an ARDS dataset
  \item \code{\link{get_ards}}: Extract the completed ARDS
}
Click on the links above for more information about each function.

The following figure describes the structure of the ARDS dataset.  This
structure is recommended by CDISC.
\figure{structure.png}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://ards.r-sassy.org}
  \item \url{https://github.com/dbosak01/ards}
  \item Report bugs at \url{https://github.com/dbosak01/ards/issues}
}

}
\author{
\strong{Maintainer}: David Bosak \email{dbosak01@gmail.com}

Other contributors:
\itemize{
  \item Kevin Kramer \email{kkrame02@amgen.com} [contributor]
  \item Jack Fuller \email{jacfulle@amgen.com} [contributor]
  \item Matt Baldwin \email{mbaldw01@amgen.com} [contributor]
}

}
\keyword{internal}
