% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_egress_only_internet_gateway}
\alias{ec2_create_egress_only_internet_gateway}
\title{Create Egress Only Internet Gateway}
\usage{
ec2_create_egress_only_internet_gateway(
  VpcId,
  ClientToken = NULL,
  DryRun = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{VpcId}{Character. The ID of the VPC for which to create the egress-only internet gateway.}

\item{ClientToken}{Character. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{TagSpecification}{List. The tags to assign to the egress-only internet gateway.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
[IPv6 only] Creates an egress-only internet
gateway for your VPC. An egress-only internet gateway is used to enable
outbound communication over IPv6 from instances in your VPC to the
internet, and prevents hosts outside of your VPC from initiating an IPv6
connection with your instance.
}
\section{VpcId}{

The ID of the VPC for which
to create the egress-only internet gateway.
}

\section{ClientToken}{

Unique,
case-sensitive identifier that you provide to ensure the idempotency of
the request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{How to Ensure Idempotency}.
}

\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{TagSpecification}{

The tags
to assign to the egress-only internet gateway.
}

