% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_spot_datafeed_subscription}
\alias{ec2_create_spot_datafeed_subscription}
\title{Create Spot Datafeed Subscription}
\usage{
ec2_create_spot_datafeed_subscription(
  Bucket,
  DryRun = NULL,
  Prefix = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{Bucket}{Character. The name of the Amazon S3 bucket in which to store the Spot Instance data feed.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Prefix}{Character. The prefix for the data feed file names.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Creates a data feed for Spot Instances, enabling
you to view Spot Instance usage logs. You can create one data feed per
AWS account. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html}{Spot Instance data feed}
in the \emph{Amazon EC2 User Guide for Linux Instances}.
}
\section{Bucket}{

The name
of the Amazon S3 bucket in which to store the Spot Instance data feed.
For more information about bucket names, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/BucketRestrictions.html#bucketnamingrules}{Rules for bucket naming}
in the \emph{Amazon S3 Developer Guide}.
}

\section{DryRun}{

Checks whether
you have the required permissions for the action, without actually
making the request, and provides an error response. If you have the
required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{Prefix}{

The prefix
for the data feed file names.
}

