% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_enable_vpc_classic_link}
\alias{ec2_enable_vpc_classic_link}
\title{Enable Vpc Classic Link}
\usage{
ec2_enable_vpc_classic_link(
  VpcId,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{VpcId}{Character. The ID of the VPC.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Enables a VPC for ClassicLink. You can
then link EC2-Classic instances to your ClassicLink-enabled VPC to allow
communication over private IP addresses. You cannot enable your VPC for
ClassicLink if any of your VPC route tables have existing routes for
address ranges within the \verb{10.0.0.0/8} IP address range, excluding local
routes for VPCs in the \verb{10.0.0.0/16} and \verb{10.1.0.0/16} IP address
ranges. For more information, see
\href{https://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/}{ClassicLink}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{VpcId}{

The ID of the
VPC.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

