% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credential-azure-cli.R
\name{az_cli_login}
\alias{az_cli_login}
\title{Azure CLI Device Code Login}
\usage{
az_cli_login(tenant_id = NULL, use_bridge = FALSE, verbose = FALSE)
}
\arguments{
\item{tenant_id}{A character string specifying the Azure Active Directory
tenant ID to authenticate against. If \code{NULL} (default), uses the default
tenant from Azure CLI configuration.}

\item{use_bridge}{A logical value indicating whether to use the device code
bridge webpage. If \code{TRUE}, launches an intermediate local webpage that
displays the device code and facilitates copy-pasting before redirecting
to the Microsoft device login page. If \code{FALSE} (default), copies the code
directly to the clipboard and opens the Microsoft login page.}

\item{verbose}{A logical value indicating whether to print detailed process
output to the console, including error messages from the Azure CLI process.
If \code{FALSE} (default), only essential messages are displayed.}
}
\value{
Invisibly returns the exit status (0 for success, non-zero for failure)
}
\description{
Performs an interactive Azure CLI login using device code flow.
Automatically captures the device code, copies it to the clipboard,
and opens the browser for authentication.
}
\details{
This function runs \verb{az login --use-device-code}, monitors the output
to extract the device code, copies it to the clipboard, and opens
the authentication URL in the default browser.
}
\examples{
\dontrun{
# Perform Azure CLI login with device code flow
az_cli_login()

# Use the bridge webpage for easier code handling
az_cli_login(use_bridge = TRUE)

# Login to a specific tenant with verbose output
az_cli_login(tenant_id = "your-tenant-id", verbose = TRUE)
}

}
