% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credential-interactive.R
\name{DeviceCodeCredential}
\alias{DeviceCodeCredential}
\title{Device code credential authentication}
\description{
Authenticates a user through the device code flow. This flow is designed for
devices that don't have a web browser or have input constraints.
}
\details{
The device code flow displays a code that the user must enter on another
device with a web browser to complete authentication. This is ideal for
CLI applications, headless servers, or devices without a browser.

The credential supports token caching to avoid repeated authentication.
Tokens can be cached to disk or in memory.
}
\examples{
# DeviceCodeCredential requires an interactive session
\dontrun{
# Create credential with default settings
cred <- DeviceCodeCredential$new()

# Get an access token (will prompt for 'device code' flow)
token <- cred$get_token()

# Force re-authentication
token <- cred$get_token(reauth = TRUE)

# Use with httr2 request
req <- httr2::request("https://management.azure.com/subscriptions")
req <- cred$req_auth(req)
}
}
\section{Super classes}{
\code{azr::Credential} -> \code{\link[azr:InteractiveCredential]{azr::InteractiveCredential}} -> \code{DeviceCodeCredential}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DeviceCodeCredential-new}{\code{DeviceCodeCredential$new()}}
\item \href{#method-DeviceCodeCredential-get_token}{\code{DeviceCodeCredential$get_token()}}
\item \href{#method-DeviceCodeCredential-req_auth}{\code{DeviceCodeCredential$req_auth()}}
\item \href{#method-DeviceCodeCredential-clone}{\code{DeviceCodeCredential$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="azr" data-topic="Credential" data-id="print"><a href='../../azr/html/Credential.html#method-Credential-print'><code>azr::Credential$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="azr" data-topic="Credential" data-id="validate"><a href='../../azr/html/Credential.html#method-Credential-validate'><code>azr::Credential$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="azr" data-topic="InteractiveCredential" data-id="is_interactive"><a href='../../azr/html/InteractiveCredential.html#method-InteractiveCredential-is_interactive'><code>azr::InteractiveCredential$is_interactive()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DeviceCodeCredential-new"></a>}}
\if{latex}{\out{\hypertarget{method-DeviceCodeCredential-new}{}}}
\subsection{Method \code{new()}}{
Create a new device code credential
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DeviceCodeCredential$new(
  scope = NULL,
  tenant_id = NULL,
  client_id = NULL,
  use_cache = "disk",
  offline = TRUE,
  interactive = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scope}}{A character string specifying the OAuth2 scope. Defaults to \code{NULL}.}

\item{\code{tenant_id}}{A character string specifying the Azure Active Directory
tenant ID. Defaults to \code{NULL}.}

\item{\code{client_id}}{A character string specifying the application (client) ID.
Defaults to \code{NULL}.}

\item{\code{use_cache}}{A character string specifying the cache type. Use \code{"disk"}
for disk-based caching or \code{"memory"} for in-memory caching. Defaults to \code{"disk"}.}

\item{\code{offline}}{A logical value indicating whether to request offline access
(refresh tokens). Defaults to \code{TRUE}.}

\item{\code{interactive}}{A logical value indicating whether this credential
requires user interaction. Defaults to \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{DeviceCodeCredential} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DeviceCodeCredential-get_token"></a>}}
\if{latex}{\out{\hypertarget{method-DeviceCodeCredential-get_token}{}}}
\subsection{Method \code{get_token()}}{
Get an access token using device code flow
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DeviceCodeCredential$get_token(reauth = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reauth}}{A logical value indicating whether to force reauthentication.
Defaults to \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{\link[httr2:oauth_token]{httr2::oauth_token()}} object containing the access token
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DeviceCodeCredential-req_auth"></a>}}
\if{latex}{\out{\hypertarget{method-DeviceCodeCredential-req_auth}{}}}
\subsection{Method \code{req_auth()}}{
Add OAuth device code authentication to an httr2 request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DeviceCodeCredential$req_auth(req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{req}}{An \code{\link[httr2:request]{httr2::request()}} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The request object with OAuth device code authentication configured
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DeviceCodeCredential-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DeviceCodeCredential-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DeviceCodeCredential$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
