% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{priors}
\alias{priors}
\title{Priors for Intercept, Main Effects, Interactions}
\description{
The models created with \code{\link[=mod_pois]{mod_pois()}}, \code{\link[=mod_binom]{mod_binom()}},
and \code{\link[=mod_norm]{mod_norm()}} include terms such as age effects
and region-time interactions. Each of these terms
requires a prior distribution. Current options
for these priors are summarised in the table below.
}
\details{
\tabular{lllll}{
   \strong{Prior} \tab \strong{Description} \tab \strong{Uses} \tab \strong{Forecast} \tab \strong{Along/By} \cr
   \code{\link[=N]{N()}} \tab Elements drawn from normal distribution \tab Term with no natural order \tab Yes \tab No \cr
   \code{\link[=NFix]{NFix()}} \tab \code{N()} with standard deviation fixed \tab Term with few elements \tab Yes \tab No \cr
   \code{\link[=Known]{Known()}} \tab Values treated as known \tab Simulations, prior knowledge \tab No \tab No \cr
   \code{\link[=RW]{RW()}} \tab Random walk \tab Smoothing \tab Yes \tab Yes \cr
   \code{\link[=RW2]{RW2()}} \tab Second-order random walk \tab Like \code{RW()}, but with trends \tab Yes \tab Yes \cr
   \code{\link[=DRW]{DRW()}} \tab Damped random walk \tab Smoothing, forecasting \tab Yes \tab Yes \cr
   \code{\link[=DRW2]{DRW2()}} \tab Damped second-order random walk \tab Like \code{DRW()}, but with trends \tab Yes \tab Yes \cr
   \code{\link[=RW2_Infant]{RW2_Infant()}} \tab \code{RW2()} with infant indicator \tab Mortality age profiles \tab No \tab Yes \cr
   \code{\link[=RW_Seas]{RW_Seas()}} \tab \code{RW()}, with seasonal effect \tab Terms involving time \tab Yes \tab Yes \cr
   \code{\link[=RW2_Seas]{RW2_Seas()}} \tab \code{RW2()}, with seasonal effect \tab Term involving time \tab Yes \tab Yes \cr
   \code{\link[=AR]{AR()}} \tab Auto-regressive prior of order \emph{k} \tab Mean reversion, forecasting \tab Yes \tab Yes \cr
   \code{\link[=AR1]{AR1()}} \tab Special case of \code{AR()} \tab Mean reversion, forecasting \tab Yes \tab Yes \cr
   \code{\link[=Lin]{Lin()}} \tab Linear trend, with independent errors \tab Parsimonious model for time \tab Yes \tab Yes \cr
   \code{\link[=Lin_AR]{Lin_AR()}} \tab Linear trend, with AR errors \tab Term involving time, forecasting \tab Yes \tab Yes \cr
   \code{\link[=Lin_AR1]{Lin_AR1()}} \tab Linear trend, with AR1 errors \tab Terms involving time, forecasting \tab Yes \tab Yes \cr
   \code{\link[=Sp]{Sp()}} \tab P-Spline (penalised spline) \tab Smoothing, eg over age \tab No \tab Yes \cr
   \code{\link[=SVD]{SVD()}} \tab Age-sex profile based on SVD \tab Age or age-sex \tab No \tab No \cr
   \code{\link[=SVD_AR]{SVD_AR()}} \tab \code{SVD()}, but coefficients follow \code{AR()} \tab Age or age-sex and time \tab Yes \tab Yes \cr
   \code{\link[=SVD_AR1]{SVD_AR1()}} \tab \code{SVD()}, but coefficients follow \code{AR1()} \tab Age or age-sex and time \tab Yes \tab Yes \cr
   \code{\link[=SVD_Lin]{SVD_Lin()}} \tab \code{SVD()}, but coefficients follow \code{Lin()} \tab Age or age-sex and time \tab Yes \tab Yes \cr
   \code{\link[=SVD_RW]{SVD_RW()}} \tab \code{SVD()}, but coefficients follow \code{RW()} \tab Age or age-sex and time \tab Yes \tab Yes \cr
   \code{\link[=SVD_RW2]{SVD_RW2()}} \tab \code{SVD()}, but coefficients follow \code{RW2()} \tab Age or age-sex and time \tab Yes \tab Yes \cr
   \code{\link[=SVD_DRW]{SVD_DRW()}} \tab \code{SVD()}, but coefficients follow \code{DRW()} \tab Age or age-sex and time \tab Yes \tab Yes \cr
   \code{\link[=SVD_DRW2]{SVD_DRW2()}} \tab \code{SVD()}, but coefficients follow \code{DRW2()} \tab Age or age-sex and time \tab Yes \tab Yes \cr
}
}
\section{'Along' and 'by' dimensions}{


Priors for interaction terms often consist of a time-series-style model
along one dimension, with a separate series for each
combination of the remaining dimensions. For instance,
a prior for an age-sex-time interaction might
consist of a separate random walk along time
for each combination of age-group and sex.
In \pkg{bage} the dimension with the time-series-type model is
referred to as the 'along' dimension, and the remaining dimensions
are referred to as the 'by' dimensions.
}

\section{Default prior}{


If no prior is specified for a term, then \pkg{bage} assigns the term a default prior using
the following algorithm:
\itemize{
\item if the term has one or two elements, use \code{\link[=NFix]{NFix()}};
\item otherwise, if the term involves time, use \code{\link[=RW]{RW()}}, with time as the 'along' dimension;
\item otherwise, if the term involves age, use \code{\link[=RW]{RW()}}, with age as the 'along' dimension;
\item otherwise, use \code{\link[=N]{N()}}.
}
}

\section{Forecasting}{


A model can only be used for forecasting if
\itemize{
\item the model includes a time dimension, and
\item the prior for the time dimension supports forecasting.
}

If necessary, the time dimension can be identified
using \code{\link[=set_var_time]{set_var_time()}}. The table above lists the
priors that support forecasting.
}

