% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{syn_nssp_df}
\alias{syn_nssp_df}
\title{A synthetic dataset containing the number of incident cases indexed by
reference date and report date. While data of this form could be from any
source, this data is meant to represent the output of pre-processing the
\link{syn_nssp_line_list} dataset, which is a synthetic patient-level line list
data from the United State's National Syndromic Surveillance System (NSSP).}
\format{
A data.frame with 3795 rows and 3 columns.
\describe{
\item{reference_date}{Date the primary event occurred (e.g. date of
hospital admissions, specimen collection date, symptom onset), formatted
in ISO8601 standards as YYYY-MM-DD.}
\item{report_date}{Date the event was reported into the surveillance
system, formatted as YYYY-MM-DD.}
\item{count}{Number of incident events (e.g. cases) occurring on the
specified reference date and reported on the report date.}
}
}
\source{
Created for package demonstration, made to look like the output after
preprocessing the line-list data to obtain the number of incidence cases
of a specific syndromic surveillance definition, indexed by the date of
admission (reference date) and the date of the diagnoses being reported to
the surveillance system (report date) (e.g. a reporting triangle in
long format).
}
\usage{
syn_nssp_df
}
\description{
A synthetic dataset containing the number of incident cases indexed by
reference date and report date. While data of this form could be from any
source, this data is meant to represent the output of pre-processing the
\link{syn_nssp_line_list} dataset, which is a synthetic patient-level line list
data from the United State's National Syndromic Surveillance System (NSSP).
}
\seealso{
Example datasets
\code{\link{example_downward_corr_rt}},
\code{\link{example_reporting_triangle}},
\code{\link{germany_covid19_hosp}},
\code{\link{syn_nssp_line_list}}
}
\concept{example_data}
\keyword{datasets}
