% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_topics_df.R
\name{get_topics_df}
\alias{get_topics_df}
\title{Get Topics DataFrame Function}
\usage{
get_topics_df(model, return_tibble = TRUE)
}
\arguments{
\item{model}{A BERTopic model object. Must be passed from the calling environment.}

\item{return_tibble}{Logical. If TRUE, returns a tibble. If FALSE, returns a data.frame. Default is TRUE.}
}
\value{
A data.frame or tibble with columns for the word, score, and topic number across all topics.
}
\description{
This function retrieves all topics from a BERTopic model and converts them into a data frame or tibble format.
}
\examples{
\donttest{
if (exists("topic_model")) {
  topics_df <- get_topics_df(model = topic_model)
  print(topics_df)
} else {
  message("No topic_model found. Please train or load a model first.")
}
}
}

