% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ajust_pagin.R
\name{ajust_pagin}
\alias{ajust_pagin}
\title{Function of standardizing spacing between Scopus and Web of Science pages}
\usage{
ajust_pagin(input_ent)
}
\arguments{
\item{input_ent}{input_ent is a dataframe with the list of main scientifics references generated by the principal_listr function}
}
\value{
This function returns a dataframe object containing the main list of articles, with the spacing between article pages adjusted to the standard bibtex format.
}
\description{
This function adjusts the spacing between article pages to the standard bibtex format.
}
\examples{

#Call the principal_lister function
input_tam <- 100
file_db <- system.file("extdata","example_database.csv", package = "bibliorefer")
separator <- ";"
input_date <- example_database(file_db, separator)
principal_refer <- principal_lister(input_date,input_tam)

#Call the ajust_pagin function
ajust_space <- ajust_pagin(principal_refer)
ajust_space

}
\references{
1 - Asymptotic Theory of Statistics and Probability. Anirban DasGupta. New York: Springer Science+Business Media, LLC, 2008.

2 - Quantitative science studies should be framed with middle-range theories and concepts from the social sciences Heinze, T.,  Jappe, A. Quantitative Science Studies, 1(3), pp. 983–992, 2020
}
