% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bids.R
\name{func_scans.bids_project}
\alias{func_scans.bids_project}
\title{Get Functional Scans from a BIDS Project}
\usage{
\method{func_scans}{bids_project}(
  x,
  subid = ".*",
  task = ".*",
  run = ".*",
  session = ".*",
  kind = "bold",
  full_path = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{bids_project} object.}

\item{subid}{Regular expression for matching subject IDs. Default is ".*".}

\item{task}{Regular expression for matching task names. Default is ".*".}

\item{run}{Regular expression for matching run numbers. Default is ".*".}

\item{session}{Regular expression for matching session IDs. Default is ".*".}

\item{kind}{Regular expression for matching scan type. Default is "bold".}

\item{full_path}{Logical. If TRUE, return full file paths. If FALSE, return
relative paths. Default is TRUE.}

\item{...}{Additional arguments (not currently used).}
}
\value{
A character vector of file paths to functional scans matching the criteria.
Returns NULL if:
\itemize{
\item No matching files are found
\item The project doesn't contain functional data
\item The specified criteria don't match any files
}
}
\description{
This method extracts functional scan files from a BIDS project based on specified
criteria such as subject ID, task name, run number, and session. It can return
either full or relative file paths to the functional scans.
}
\examples{
\donttest{
# Create a BIDS project
tryCatch({
  ds001_path <- get_example_bids_dataset("ds001")
  proj <- bids_project(ds001_path)
  
  # Get all functional scans
  all_scans <- func_scans(proj)
  
  # Get scans for specific subjects
  sub_scans <- func_scans(proj, subid="0[123]")
  
  # Get scans for a specific task
  task_scans <- func_scans(proj, task="rest")
  
  # Get scans from specific runs
  run_scans <- func_scans(proj, run="0[123]")
  
  # Combine multiple filters
  filtered_scans <- func_scans(proj,
                              subid="01",
                              task="rest",
                              run="01")
  
  # Get relative paths instead of full paths
  rel_scans <- func_scans(proj, full_path=FALSE)
  
  # Clean up
  unlink(ds001_path, recursive=TRUE)
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}

}
