% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/big_pls_cox_gd_diagnostics.R
\name{gd_diagnostics}
\alias{gd_diagnostics}
\title{Extract Diagnostics from a big_pls_cox_gd Model}
\usage{
gd_diagnostics(object)
}
\arguments{
\item{object}{A model returned by \code{big_pls_cox_gd()}.}
}
\value{
A list with log-likelihood, step sizes, gradient norms.
}
\description{
Extract Diagnostics from a big_pls_cox_gd Model
}
\examples{
library(bigmemory)
set.seed(1)
n <- 50
p <- 10
X <- bigmemory::as.big.matrix(matrix(rnorm(n * p), n, p))
time <- rexp(n, rate = 0.1)
status <- rbinom(n, 1, 0.7)
fit <- big_pls_cox_gd(X, time, status, ncomp = 3, max_iter = 200)
str(fit)
head(fit$scores)
gd_diagnostics(fit)
}
